define([
    'backbone',
    'underscore',
    'modules/page/popup/popup-view',
    'text!modules/appointments/cancellation/cancellation-success.html',
], function(Backbone, _, PopupView, template) {
    'use strict';

    return PopupView.extend({
        template: _.template(template),
        events: _.extend({}, PopupView.prototype.events, {
            'popupbeforeposition': 'styleMaxHeight',
            'popupafteropen': 'focusOnHeader',
        }),
        initialize: function(options) {
            this._modelType = options.modelType;
            this._initializeElAfterClose(options);
        },
        closePopup: function() {
            this.$el.popup('close');
            this.routeToAppointments();
        },
        routeToAppointments: function() {
            Backbone.history.navigate('appointments', {trigger: true});
        },
        templateContext: function() {
            return {
                modelType: this._modelType,
                toTitleCase: function(string) {
                    return string.replace(/\w*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                },
            };
        },
    });
});
